/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.SyncFormationsLevelDataPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class FormationsLevelData {
    public static FormationsLevelData SERVER = new FormationsLevelData();
    public static FormationsLevelData CLIENT = new FormationsLevelData();
    private boolean devMode;

    public static void registerListeners() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> SERVER.syncToPlayer((class_1657)handler.field_14140));
    }

    private FormationsLevelData() {
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        if (this.devMode == devMode) {
            return;
        }
        this.devMode = devMode;
        if (this == SERVER) {
            this.syncToAll();
        }
    }

    public void save(MinecraftServer server) {
        Path file = server.field_23784.method_27010(class_5218.field_24188).resolve("formations-data");
        try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
            stream.write(this.devMode ? 1 : 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(MinecraftServer server) {
        block9: {
            Path file = server.field_23784.method_27010(class_5218.field_24188).resolve("formations-data");
            if (Files.exists(file, new LinkOption[0])) {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    this.devMode = stream.read() == 1;
                    break block9;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.devMode = false;
        }
    }

    public void syncToPlayer(class_1657 player) {
        FormationsDev.CHANNEL.sendToPlayer(player, (BasePacket)new SyncFormationsLevelDataPacket(this.devMode));
    }

    public void syncToAll() {
        FormationsDev.CHANNEL.sendToAllPlayers((BasePacket)new SyncFormationsLevelDataPacket(this.devMode));
    }
}

